/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.lib.util.helpers.ItemHelper;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public abstract class ItemToolAdv
extends ItemTool {
    public String repairIngot = "";
    private final TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    private final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    protected THashSet<Block> effectiveBlocks = new THashSet();
    protected THashSet<Material> effectiveMaterials = new THashSet();
    protected int harvestLevel = -1;
    protected boolean showInCreative = true;

    public ItemToolAdv(float f, Item.ToolMaterial toolMaterial) {
        super(f, toolMaterial, null);
    }

    public ItemToolAdv(float f, Item.ToolMaterial toolMaterial, int n) {
        this(f, toolMaterial);
        this.harvestLevel = n;
    }

    public ItemToolAdv setRepairIngot(String string) {
        this.repairIngot = string;
        return this;
    }

    public ItemToolAdv setShowInCreative(boolean bl) {
        this.showInCreative = bl;
        return this;
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        if (this.showInCreative) {
            list.add(new ItemStack(item, 1, 0));
        }
    }

    protected void addToolClass(String string) {
        this.toolClasses.add((Object)string);
    }

    protected THashSet<Block> getEffectiveBlocks(ItemStack itemStack) {
        return this.effectiveBlocks;
    }

    protected THashSet<Material> getEffectiveMaterials(ItemStack itemStack) {
        return this.effectiveMaterials;
    }

    protected boolean harvestBlock(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        int n4;
        Block block;
        if (world.isAirBlock(n, n2, n3)) {
            return false;
        }
        EntityPlayerMP entityPlayerMP = null;
        if (entityPlayer instanceof EntityPlayerMP) {
            entityPlayerMP = (EntityPlayerMP)entityPlayer;
        }
        if (!this.toolClasses.contains((Object)(block = world.getBlock(n, n2, n3)).getHarvestTool(n4 = world.getBlockMetadata(n, n2, n3))) && !this.canHarvestBlock(block, entityPlayer.getCurrentEquippedItem())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)entityPlayer, (int)n4)) {
            return false;
        }
        BlockEvent.BreakEvent breakEvent = null;
        if (entityPlayerMP != null && (breakEvent = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)entityPlayerMP.theItemInWorldManager.getGameType(), (EntityPlayerMP)entityPlayerMP, (int)n, (int)n2, (int)n3)).isCanceled()) {
            return false;
        }
        if (entityPlayer.capabilities.isCreativeMode) {
            if (!world.isRemote) {
                block.onBlockHarvested(world, n, n2, n3, n4, entityPlayer);
            } else {
                world.playAuxSFX(2001, n, n2, n3, Block.getIdFromBlock((Block)block) | n4 << 12);
            }
            if (block.removedByPlayer(world, entityPlayer, n, n2, n3, false)) {
                block.onBlockDestroyedByPlayer(world, n, n2, n3, n4);
            }
            if (!world.isRemote) {
                entityPlayerMP.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(n, n2, n3, world));
            } else {
                Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)new C07PacketPlayerDigging(2, n, n2, n3, Minecraft.getMinecraft().objectMouseOver.sideHit));
            }
            return true;
        }
        world.playAuxSFXAtEntity(entityPlayer, 2001, n, n2, n3, Block.getIdFromBlock((Block)block) | n4 << 12);
        if (!world.isRemote) {
            block.onBlockHarvested(world, n, n2, n3, n4, entityPlayer);
            if (block.removedByPlayer(world, entityPlayer, n, n2, n3, true)) {
                block.onBlockDestroyedByPlayer(world, n, n2, n3, n4);
                block.harvestBlock(world, entityPlayer, n, n2, n3, n4);
                if (breakEvent != null) {
                    block.dropXpOnBlockBreak(world, n, n2, n3, breakEvent.getExpToDrop());
                }
            }
            entityPlayerMP.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(n, n2, n3, world));
        } else {
            if (block.removedByPlayer(world, entityPlayer, n, n2, n3, true)) {
                block.onBlockDestroyedByPlayer(world, n, n2, n3, n4);
            }
            Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)new C07PacketPlayerDigging(2, n, n2, n3, Minecraft.getMinecraft().objectMouseOver.sideHit));
        }
        return true;
    }

    protected boolean isClassValid(String string, ItemStack itemStack) {
        return true;
    }

    protected boolean isValidHarvestMaterial(ItemStack itemStack, World world, int n, int n2, int n3) {
        return this.getEffectiveMaterials(itemStack).contains((Object)world.getBlock(n, n2, n3).getMaterial());
    }

    protected int getHarvestLevel(ItemStack itemStack, int n) {
        return n;
    }

    protected float getEfficiency(ItemStack itemStack) {
        return this.efficiencyOnProperMaterial;
    }

    public String getToolMaterialName() {
        return super.getToolMaterialName().contains(":") ? super.getToolMaterialName().split(":", 2)[1] : super.getToolMaterialName();
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return this.func_150893_a(itemStack, block) > 1.0f;
    }

    public boolean getIsRepairable(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.isOreNameEqual(itemStack2, this.repairIngot);
    }

    public boolean isItemTool(ItemStack itemStack) {
        return true;
    }

    public int getHarvestLevel(ItemStack itemStack, String string) {
        if (this.harvestLevel != -1) {
            return this.harvestLevel;
        }
        int n = super.getHarvestLevel(itemStack, string);
        if (n == -1 && this.isClassValid(string, itemStack) && this.toolClasses.contains((Object)string)) {
            n = this.toolMaterial.getHarvestLevel();
        }
        return this.getHarvestLevel(itemStack, n);
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        return this.getEffectiveMaterials(itemStack).contains((Object)block.getMaterial()) || this.getEffectiveBlocks(itemStack).contains((Object)block) ? this.getEfficiency(itemStack) : 1.0f;
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int n) {
        for (String string : this.getToolClasses(itemStack)) {
            int n2 = this.getHarvestLevel(itemStack, string);
            if (!string.equals(block.getHarvestTool(n)) || block.getHarvestLevel(n) >= n2) continue;
            return this.getEfficiency(itemStack);
        }
        return super.getDigSpeed(itemStack, block, n);
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return this.toolClasses.isEmpty() ? super.getToolClasses(itemStack) : this.immutableClasses;
    }
}

